<?php

$route->group(null)->namespace('Amwdeveloper\plugins\webshop');
$route->get("/shops", "home:shoppings");

if (plugin()->shopping_unique) {
    $route->get("/shop/{category}", "home:shoppingredirectcategory");
    $route->get("/shop/{category}/{group}", "home:shoppingcategory");
    $route->get("/shop/{category}/{group}/item/details/{id}", "home:buyitemdetails");
}

if (plugin()->shopping_kits) {
    $route->group("kit")->namespace('Amwdeveloper\plugins\webshop');
    $route->get("/shop/{category}", "home:shoppingkitcategory");
    $route->get("/shop/{category}/{group}", "home:shoppingkitcategorygroup");
}

$route->group("shopping")->namespace('Amwdeveloper\plugins\webshop');

if (plugin()->shopping_unique) {
    $route->post("/buy/item", "home:buyitem");
}

if (plugin()->shopping_kits) {
    $route->post("/buy/kit/item", "home:buykititem");
}

/** Administration Router */
$route->group('administration')->namespace('Amwdeveloper\plugins\webshop');
$route->get("/shopping/add/new/item", "admin:shoppingaddnewitem");
$route->get("/shopping/add/itemtxt", "admin:shoppingitemtxt");
$route->get("/shopping/all/itens", "admin:shoppingallitem");
$route->get("/shopping/to/edit/item/{id}", "admin:shoppingtoedit");
$route->get("/shopping/to/remove/item/{id}", "admin:shoppingtoremove");
$route->get('/shopping/logs', "admin:shoppinglogs");

//Kits
$route->get("/shopping/kit/add/category", "admin:shoppingkitaddcategory");
$route->get("/shopping/kit/manage/category", "admin:shoppingkitmanagecategory");

$route->get("/shopping/add/new/kit/category/{id}", "admin:shoppingaddnewkitcategory");
$route->get("/shopping/to/edit/kit/category/{id}", "admin:shoppingaddeditkitcategory");
$route->get("/shopping/to/edit/kit/{id}", "admin:shoppingtoeditkit");


$route->get("/shopping/to/remove/kit/category/{id}", "admin:shoppingremovekitcategory");
$route->get("/shopping/to/remove/kit/all/{id}/{category}", "admin:shoppingremovekitall");

$route->get("/shopping/to/add/items/kit/{id}", "admin:shoppingadditemskit");
$route->get("/shopping/to/remove/item/kit/{id}/{category}", "admin:shoppingremoveitemskit");

/** Administration Post */
$route->post("/auth/add/itemtxt", "admin:authadditemtxt");
$route->post("/auth/add/new/item", "admin:authaddnewitem");
$route->post("/auth/to/edit/item/{id}", "admin:authtoeditoitem");

// post kits

$route->post("/auth/add/new/kit/category", "admin:authaddnewkitcategory");
$route->post("/auth/add/new/item/kit", "admin:authaddnewitemkit");
$route->post("/auth/edit/kit/category/{id}", "admin:autheditkitcategory");
$route->post("/auth/add/new/kit/category/all/{id}", "admin:authaddnewkitcategoryall");
$route->post("/auth/edit/kit/category/all/{id}", "admin:autheditkitcategoryall");
