<?php

namespace Amwdeveloper\view;

use Amwdeveloper\model\layer;
use Amwdeveloper\plugins\{
    hallfame\home as hallfame,
    hallfame\geral as geral,
    posts\home as posts,
    sliders\home as slider,
    market\view as market
};
use Amwdeveloper\plugins\market\character\inventory;
use League\Plates\Engine;

class web
{

    private $route;
    private $view;
    private $title;

    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title = config['web_title'];
    }

    public function index()
    {
        if (isset($_GET['ref'])) {
            if (!empty($_GET['ref'])) {
                $idRef = filter_input(INPUT_GET, 'ref', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
                if ($idRef) {
                    $layer = (new layer());
                    $user = $layer->table("MEMB_INFO")->columns("memb___id")->where("id_ref = :r", "r={$idRef}")->get();
                    if (!$user) $idRef = null;
                }
            }
        }

        echo $this->view->render('home', [
            'title' =>  $this->title . ' - Início',
            'hallfame' => (new hallfame())->render(),
            'hallfame_events' => (new hallfame())->renderevents(),
            'castle_siege' => (new hallfame())->castlesiege(),
            "posts" => (new posts())->index(),
            "sliders" => (new slider())->index(),
            'market' => (new market())->itemshome(),
            'idRef' => $idRef ?? null
        ]);
    }

    public function register()
    {
        if (isset($_GET['ref'])) {
            if (!empty($_GET['ref'])) {
                $idRef = filter_input(INPUT_GET, 'ref', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
                if ($idRef) {
                    $layer = (new layer());
                    $user = $layer->table("MEMB_INFO")->columns("memb___id")->where("id_ref = :r", "r={$idRef}")->get();
                    if (!$user) $idRef = null;
                }
            }
        }

        echo $this->view->render("register", [
            'title' => $this->title . ' - Criar conta',
            'idRef' => $idRef ?? null
        ]);
    }

    public function info()
    {
        echo $this->view->render("info", [
            'title' => $this->title . ' - Informações do servidor'
        ]);
    }

    public function vip()
    {
        echo $this->view->render("vip", [
            'title' => $this->title . ' - Vip\'s'
        ]);
    }
    public function coin()
    {
        echo $this->view->render("coin", [
            'title' => $this->title . ' - Moeda\'s'
        ]);
    }

    public function rankings()
    {
        echo $this->view->render("partials/rankings/ranking", [
            'title' => $this->title . ' - Rankings'
        ]);
    }

    public function rankinggerate($request)
    {
        (new geral())->verifyrankingexist($request);

        echo $this->view->render("partials/rankings/gerate", [
            'title' => $this->title . " Ranking - {$request['gerate']}",
            'gerate' => (new geral())->render($request)
        ]);
    }

    public function postview($request)
    {
        (new posts())->verifyexitpost($request);

        $post = (new posts())->viewpost($request);
        $comments = (new posts())->commentspost($post['id']);
        echo $this->view->render("partials/post/view", [
            'title' => $this->title . " Ranking - {$request['slug']}",
            'post' => $post,
            'comments' => $comments
        ]);
    }

    public function download()
    {
        echo $this->view->render("partials/download/all", [
            'title' => $this->title . ' Downloads',
            'downloads' => (new \Amwdeveloper\core\geral())->downloadall() ?? null
        ]);
    }

    public function preview($request)
    {
        $name = filter_var($request['name'], FILTER_SANITIZE_SPECIAL_CHARS);
        $type = filter_var($request['type'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (empty($name) or empty($type) or ($type != "char" and $type != "guild")) {
            return $this->route->redirect("/");
        }

        $layer = (new layer());
        $data = [];
        if ($type == "char") {
            $details = $layer->table("Character")
                ->columns('AccountID as account,Imagem as avatar,Name as name,Strength as strength,Leadership as leadership,Dexterity as dexterity,Energy as energy,Vitality as vitality,' . columns_score_perfil['resets'] . ' as resets,' . columns_score_perfil['mresets'] . ' as mresets, Class as class,cLevel as level')->where("Name = :name", "name={$name}")->get();
            if (!$details) return $this->route->redirect("/");
            $guild = $layer->table("GuildMember")->where("Name = :name", "name={$name}")->get();
            if ($guild_logo = $guild) $guild_logo = $layer->table("Guild")->where("G_Name = :name", "name={$guild->G_Name}")->get();
            $status = $layer->table("MEMB_STAT")->columns("ConnectStat as connect")->where("memb___id = :acc", "acc={$details->account}")->get();
            $masterLevel = $layer->table("MasterSkillTree")->columns("MasterLevel as ml")->where("Name = :n", "n={$name}")->get();
            if ($membersCount = $guild) $membersCount = $layer->table("GuildMember")->columns("Name")->where("G_Name = :name", "name={$guild->G_Name}")->count();

            $data = [
                'name' => $details->name,
                'strength' => $details->strength,
                'dexterity' => $details->dexterity,
                'energy' => $details->energy,
                'vitality' => $details->vitality,
                'leadership' => $details->leadership,
                'resets' => $details->resets,
                'mresets' => $details->mresets,
                'kills' => $details->kills,
                'hero' => $details->hero,
                'class' => characters['classes'][$details->class]['name'],
                'class_short' => characters['classes'][$details->class]['short_name'],
                'level' => $details->level,
                'guild' => $guild->G_Name ?? '-',
                'guild_mark' => $guild_logo ? __guildmark($guild_logo->G_Mark) : null,
                'guild_score' => $guild_logo ? $guild_logo->G_Score : null,
                'guild_master' => $guild_logo ? $guild_logo->G_Master : null,
                'guild_count' => $membersCount ? $membersCount->amount : null,
                'mlevel' => $masterLevel->ml ?? 0,
                'image' => __avatar($details->avatar),
                //'inventory' => (new inventory($details->name))->CutHexSlotsInventory(),
                'status' => (empty($status) ? 'Offline' : ($status->connect == 0 ? 'Offline' : 'Online')),
                'bloc_profile' => $details->Bloc_Profile
            ];
        }

        if ($type == "guild") {
            $details = $layer->table("Guild")->columns('G_Name as name, G_Mark as mark, G_Master as master, G_Score as score')->where("G_Name = :name", "name={$name}")->get();
            if (!$details) return $this->route->redirect("/");
            $membersCount = $layer->table("GuildMember")->columns("Name")->where("G_Name = :name AND Name != :master", "name={$name}&master={$details->master}")->count();
            $members = $layer->table("GuildMember")->columns("Name as name")->where("G_Name = :name AND Name != :master", "name={$name}&master={$details->master}")->all();

            $data = [
                'name' => $details->name,
                'members_count' => $membersCount->amount,
                'members_list' => $members,
                'master' => $details->master,
                'score' => $details->score,
                'image' => __guildmark($details->mark)
            ];
        }

        echo $this->view->render('partials/preview/' . $type, [
            'title' => $this->title . ' -  Todos os personagens do mercado',
            'data' => $data
        ]);
    }

    public function confirmAccount($data)
    {
        $code = filter_var($data['code'], FILTER_SANITIZE_SPECIAL_CHARS);
        if (!$code) return $this->route->redirect("/");

        $user = (new layer())->table("MEMB_INFO")->where("email_codding = :e", "e={$code}")->get();
        if (!$user) return $this->route->redirect("/");

        (new layer())->table("MEMB_INFO")->where("email_codding = :e", "e={$code}")->updated(['mail_chek' => 1]);
        (new layer())->table("MEMB_INFO")->where("email_codding = :e", "e={$code}")->updated(['email_codding' => null]);

        echo $this->view->render("partials/mail/confirm", [
            'title' => $this->title . ' - Confirmar email'
        ]);
    }

    public function playersonline() {
        
        $details = (new layer())->columns("m.memb___id, CONVERT(varchar, m.ConnectTM, 120) as ConnectTM, m.ServerName, a.GameIDC, m.ConnectStat, c.Class, c.Name")
                            ->inner("MEMB_STAT m INNER JOIN AccountCharacter a ON (m.memb___id = a.Id) LEFT JOIN Character c ON (a.GameIDC = c.Name)")
                            ->where("ConnectStat = :c","c=1")
                            ->orderby('a.GameIDC')
                            ->all();
        
        echo $this->view->render("players-online", [
            'title' => $this->title . ' - Players Online',
            'players' => $details
        ]);
    }
}
