<?php

namespace Amwdeveloper\plugins\packages;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use League\Plates\Engine;

class view extends layer
{
    private $route;
    private $view;
    private $title_web;
    private $session;
    private $messages;
    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title_web = config['web_title'];
        $this->session = new session();
        $this->messages = new message();
    }

    public function index()
    {
        $packagesverify = $this->table("amw_packages")->all();
        $packages = array();
        foreach ($packagesverify as $package) {
            $packages[] = array(
                'id' => $package->id,
                'title' => $package->title,
                'description' => $package->description,
                'price' => $package->price,
                'coin_demand' => $package->coin_demand_name,
            );
        }
        echo $this->view->render(
            "partials/packages/view",
            [
                'title' => $this->title_web . ' -  Pacotes de Vips e Moedas',
                'packages' => $packages ?? null
            ]
        );
    }

    public function buyPackage($request)
    {
        $id = filter_var($request['item'], FILTER_VALIDATE_INT);
        if (!$id) return null;

        $package = $this->table("amw_packages")->where("id = :id", "id={$id}")->get();

        if (!$package) return null;

        $message = '';

        $myaccountvip = $this->table("MEMB_INFO")->columns("" . config['column_vip'] . " as vip,AccountExpireDate")->where("memb___id = :mi", "mi={$this->session->useraccount}")->get();

        $myaccountcoin = $this->table("{$package->table_coin_demand}")->columns("{$package->coin_demand} as coin")->where("{$package->column_account_demand} = :mi", "mi={$this->session->useraccount}")->get();

        if ($myaccountcoin->coin < $package->price) {
            $this->messages->class("error")->text("Você não possuí <strong>{$package->price} {$package->coin_demand_name}</strong> para comprar este pacote")->flash();
            return;
        }

        if (!empty($package->vip_type)) {

            if ($myaccountvip->vip == 0 or $myaccountvip->vip == $package->vip_type) {

                if ($myaccountvip->vip > 0 and date('Y-m-d H:i:s') < $myaccountvip->AccountExpireDate) {
                    $update = array('AccountExpireDate' => date('Y-m-d H:i:s', strtotime("+{$package->vip_time} days", strtotime($myaccountvip->AccountExpireDate))));
                } else {
                    $update = array(config['column_vip']  => $package->vip_type, 'AccountExpireDate' =>  date('Y-m-d H:i:s', strtotime("+{$package->vip_time} days")));
                }
                $this->table("MEMB_INFO")->where("memb___id = :mi", "mi={$this->session->useraccount}")->updated($update);
                $message .= "Foi adicionado + {$package->vip_time} dias de " . vip[$package->vip_type] . "";
            } else {
                $this->messages->class("error")->text("Sua conta é <strong>" . vip[$myaccountvip->vip] . "</strong>, não foi possível comprar o pacote!")->flash();
                return;
            }
        }

        if (!empty($package->coin) and !empty($package->quantity)) {
            $accountreceivable = $this->table("{$package->table_coin}")->columns("{$package->coin} as coin")->where("{$package->column_account} = :mi", "mi={$this->session->useraccount}")->get();
            $update = array($package->coin => ($accountreceivable->coin + $package->quantity));
            $this->table("{$package->table_coin}")->where("{$package->column_account} = :mi", "mi={$this->session->useraccount}")->updated($update);
            $message .= "<br>Foi adicionado {$package->quantity} {$package->coin_name}";
        }

        $update = array($package->coin_demand => ($myaccountcoin->coin - $package->price));
        $this->table("{$package->table_coin_demand}")->where("{$package->column_account_demand} = :mi", "mi={$this->session->useraccount}")->updated($update);

        $this->messages->class("success")->text("<em><strong>{$request['name']}</strong></em> comprado com sucesso <br> <strong>{$message}</strong> em sua conta!")->flash(true, true);
    }
}
