<?php

namespace Amwdeveloper\plugins\market;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use Amwdeveloper\plugins\market\item as MarketItem;
use League\Plates\Engine;

class view extends MarketItem
{

    private $route;
    private $view;
    private $title_web;
    private $session;
    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title_web = config['web_title'];
        $this->session = new session();
    }


    public function vault()
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        echo $this->view->render('user/market/vault', [
            'title' => $this->title_web . ' -  Meu Baú',
            'vault' => $this->vaultitems()
        ]);
    }

    public function advertiseitem($data)
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        $dataItem = [];
        foreach ($this->vaultitems() as $item) $dataItem[] = $item['hex'] ?? null;
        if (!in_array($data['hex'], $dataItem)) return $this->route->redirect('/');
        echo $this->view->render('user/market/advertise_item', ['title' => $this->title_web . ' -  Anunciar item', 'item' => $this->vaultitems(true, $data['hex'])]);
    }

    public function allitemsmarket($data)
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        $dataItem = [];
        foreach ($this->vaultitems() as $item) $dataItem[] = $item['hex'] ?? null;
        if (!in_array($data['hex'], $dataItem)) return $this->route->redirect('/');
        echo $this->view->render('user/market/advertise_item', ['title' => $this->title_web . ' -  Anunciar item', 'item' => $this->vaultitems(true, $data['hex'])]);
    }

    public function allitems()
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        $itensmarket = (new layer())->table("amw_market_items")->columns('id,hexa,tier,price,zen,bless,soul,life,chaos,creation,harmony,guardian')->orderby('id')->all();
        $dataItems = [];
        foreach ($itensmarket as $item) $dataItems[] = [
            'id' => $item->id,
            'tier' => $item->tier,
            'price' => $item->price,
            'zen' => $item->zen,
            'bless' => $item->bless,
            'soul' => $item->soul,
            'life' => $item->life,
            'chaos' => $item->chaos,
            'creation' => $item->creation,
            'guardian' => $item->guardian,
            'harmony' => $item->harmony,
            'details' => $this->vaultitems(true, $item->hexa),
            'coin_name' => market['coin_name']
        ];

        echo $this->view->render('user/market/items', ['title' => $this->title_web . ' -  Todos os itens do mercado', 'items' => $dataItems]);
    }

    public function myads()
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }



        $itensmarket = (new layer())->table("amw_market_items")->columns('id,price,hexa')->where("account = :mi", "mi=" . $this->session->{'useraccount'} . "")->orderby('id')->all();
        $dataItems = [];
        foreach ($itensmarket as $item) $dataItems[] = ['id' => $item->id, 'price' => $item->price, 'details' => $this->vaultitems(true, $item->hexa), 'coin_name' => market['coin_name']];
        echo $this->view->render('user/market/myads', ['title' => $this->title_web . ' -  Todos os itens do mercado', 'items' => $dataItems]);
    }

    public function itemshome()
    {
        $itensmarket = (new layer())->table("amw_market_items")->columns('id,hexa,tier,price,zen,bless,soul,life,chaos,creation,guardian,harmony')->orderby('id')->limit(5)->all();


        $dataItems = [];

        if (!empty($itensmarket)) {
            foreach ($itensmarket as $item) {
                $dataItems[] = [
                    'id' => $item->id,
                    'tier' => $item->tier,
                    'price' => $item->price,
                    'zen' => $item->zen,
                    'bless' => $item->bless,
                    'soul' => $item->soul,
                    'life' => $item->life,
                    'chaos' => $item->chaos,
                    'creation' => $item->creation,
                    'guardian' => $item->guardian,
                    'harmony' => $item->harmony,
                    'details' => $this->vaultitems(true, $item->hexa),
                    'coin_name' => market['coin_name']
                ];
            }
        }

        return $dataItems;
    }

    public function itemsCategory($category)
    {

        $category = filter_var($category['category'], FILTER_SANITIZE_SPECIAL_CHARS);

        $gg = '';
        foreach (group_items as $key => $group) {
            if ($group['group'] == $category) $gg = $key;
        }

        $items = $this->table("amw_market_items")->where("section = :sc", "sc={$gg}")->all();

        $dataItems = [];
        foreach ($items as $item) $dataItems[] = [
            'id' => $item->id,
            'tier' => $item->tier,
            'price' => $item->price,
            'zen' => $item->zen,
            'bless' => $item->bless,
            'soul' => $item->soul,
            'life' => $item->life,
            'chaos' => $item->chaos,
            'creation' => $item->creation,
            'guardian' => $item->guardian,
            'harmony' => $item->harmony,
            'details' => $this->vaultitems(true, $item->hexa),
            'coin_name' => market['coin_name']
        ];

        echo $this->view->render('user/market/section', [
            'title' => $this->title_web . ' -  Todos os itens do mercado',
            'title_section' => $category,
            'items' => $dataItems
        ]);
    }

    public function itemsChar($category)
    {

        $category = filter_var($category['class'], FILTER_SANITIZE_SPECIAL_CHARS);

        $class = '';
        $classFull = '';
        foreach (characters['classes'] as $key => $group) {
            if ($group['short_name'] == strtoupper($category)) {
                $class = strtolower($group['short_name']);
                $classFull = $group['name'];
            };
        }
        $className = "";
        $classIndex = 1;
        $classIndex2 = 2;
        $classIndex3 = 3;
        switch ($class) {
            case "dw":
                $className = "dw";
                break;
            case "bk":
                $className = "dk";
                break;
            case "fe":
                $className = "fe";
                break;
            case "mg":
                $className = "mg";
                break;
            case "dl":
                $className = "dl";
                break;
            case "su":
                $className = "su";
                break;
            case "rf":
                $className = "rf";
                break;
        }

        $items = $this->table("amw_market_items")->where("{$className} = :c OR {$className} = :cc OR {$className} = :ccc", "c={$classIndex}&cc={$classIndex2}&ccc={$classIndex3}")->all();

        $dataItems = [];
        foreach ($items as $item) $dataItems[] = [
            'id' => $item->id,
            'tier' => $item->tier,
            'price' => $item->price,
            'zen' => $item->zen,
            'bless' => $item->bless,
            'soul' => $item->soul,
            'life' => $item->life,
            'chaos' => $item->chaos,
            'creation' => $item->creation,
            'guardian' => $item->guardian,
            'harmony' => $item->harmony,
            'details' => $this->vaultitems(true, $item->hexa),
            'coin_name' => market['coin_name']
        ];

        echo $this->view->render('user/market/section', [
            'title' => $this->title_web . ' -  Todos os itens do mercado',
            'title_section' => $classFull,
            'items' => $dataItems
        ]);
    }

    public function itemsExc($exc)
    {

        $category = filter_var($exc['exc'], FILTER_SANITIZE_SPECIAL_CHARS);

        $dataItems = [];

        if ($category == 'hp' or $category == 'ref' or $category == 'dmg') {
            switch ($category) {
                case 'hp':
                    $category = 'hp';
                    break;
                case 'ref':
                    $category = 'reflect';
                    break;
                case 'dmg':
                    $category = 'reduce';
                    break;
            }

            $items = $this->table("amw_market_items")->where("{$category} = :c", "c=1")->all();


            foreach ($items as $item) $dataItems[] = [
                'id' => $item->id,
                'tier' => $item->tier,
                'price' => $item->price,
                'zen' => $item->zen,
                'bless' => $item->bless,
                'soul' => $item->soul,
                'life' => $item->life,
                'chaos' => $item->chaos,
                'creation' => $item->creation,
                'guardian' => $item->guardian,
                'harmony' => $item->harmony,
                'details' => $this->vaultitems(true, $item->hexa),
                'coin_name' => market['coin_name']
            ];
        }

        echo $this->view->render('user/market/section', [
            'title' => $this->title_web . ' -  Todos os itens do mercado',
            'title_section' => $category,
            'items' => $dataItems ?? null
        ]);
    }
}
