<?php

namespace Amwdeveloper\plugins\jewels;

use Amwdeveloper\core\session;
use Amwdeveloper\model\message;
use Amwdeveloper\plugins\jewels\item as Jewels;
use League\Plates\Engine;

class view extends Jewels
{

    private $route;
    private $view;
    private $title_web;
    private $session;
    private $message;
    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title_web = config['web_title'];
        $this->session = new session();
        $this->message = new message();
    }


    public function vault()
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        echo $this->view->render('user/jewels/vault', [
            'title' => $this->title_web . ' -  Meu Baú',
            'vault' => $this->vaultitems()
        ]);
    }

    public function coin()
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        echo $this->view->render('user/jewels/coin', [
            'title' => $this->title_web . ' -  Trocar moedas por jóias',
        ]);
    }

    public function tradeJewelToCoin($data)
    {
        $hex = filter_var($data['hex'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!$hex) {
            $this->message->class("error")->text("Item informado está incorreto!")->flash();
            return;
        }

        (new item())->converteJewelToCoin($hex);
    }
}
