<?php

namespace Amwdeveloper\controller;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;

class user extends layer
{
    public $session;
    public $message;

    public function sessionuser()
    {
        $this->session = new session();
        return $this->session->useraccount;
    }

    public function messageuser()
    {
        $this->message = new message();
        return $this->message;
    }

    public function coins(): array
    {
        if (defined('coins') && coins) {
            $listcoins = [];
            foreach (coins as $coin) {
                $select = $this->table($coin['table'])
                    ->columns($coin['column_coin'])
                    ->where("{$coin['column_account']} = :acc", "acc={$this->sessionuser()}")
                    ->get();

                $listcoins[] = [
                    "amount" => $select->{$coin['column_coin']} ?? 0,
                    "name"   => $coin['name_coin'] ?? '-'
                ];
            }
            return $listcoins;
        }

        return [];
    }

public function myaccount(): array
{
    $myaccount = $this->table("MEMB_INFO")
        ->columns("id_ref,memb_name,mail_addr," . config['column_vip'] . ",AccountExpireDate")
        ->where("memb___id = :mi", "mi={$this->sessionuser()}")
        ->get();

    // 🔒 Se a conta não for encontrada, evita erro e retorna dados padrão
    if (!$myaccount) {
        return [
            "name" => "Desconhecido",
            "email" => "Não informado",
            "vip" => "Nenhum",
            "coins" => [],
            "expiration" => "-",
            'link_indication' => '#',
            'indications' => 0
        ];
    }

    // 🔍 Captura IP atual
    $ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';

    // ⚙️ Protege o count() contra null
    $countResult = $this->table("amw_indication")
        ->where("user_ref = :r AND ip != :ip", "r={$this->sessionuser()}&ip={$ip}")
        ->count();

    $indications = $countResult->amount ?? 0;

    // 🔧 Proteção extra para AccountExpireDate
    $expire = !empty($myaccount->AccountExpireDate)
        ? date('d/m/Y H:i:s', strtotime($myaccount->AccountExpireDate))
        : '-';

    $information = [
        "name" => $myaccount->memb_name ?? 'Sem nome',
        "email" => $myaccount->mail_addr ?? 'Sem e-mail',
        "vip" => vip[$myaccount->{config['column_vip']}] ?? 'Free',
        "coins" => $this->coins(),
        "expiration" => $expire,
        'link_indication' => __redirect('register') . "?ref=" . ($myaccount->id_ref ?? ''),
        'indications' => $indications
    ];

    return $information;
}


    public function mycharacters(): array
    {
        $characters = $this->table("Character")
            ->columns("Name as name, Imagem as image")
            ->where("AccountID = :mi", "mi={$this->sessionuser()}")
            ->all();

        $mychars = [];
        foreach ($characters as $char) {
            $mychars[] = [
                'name'  => $char->name ?? 'Desconhecido',
                'image' => $char->image ?? null
            ];
        }

        return $mychars;
    }

    public function profilecharacter(array $nick)
    {
        global $route;
        $char = filter_var($nick['char'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (empty($char)) {
            $route->redirect("user/info");
        }

        $verifychar = $this->table("Character")
            ->columns("*")
            ->where("Name = :name AND AccountID = :acc", "name={$char}&acc={$this->sessionuser()}")
            ->get();

        if (empty($verifychar)) {
            $route->redirect("user/info");
        }

        $profile = [
            'name'        => $verifychar->Name,
            'strength'    => $verifychar->Strength,
            'dexterity'   => $verifychar->Dexterity,
            'energy'      => $verifychar->Energy,
            'vitality'    => $verifychar->Vitality,
            'class'       => $verifychar->Class,
            'level'       => $verifychar->cLevel,
            'command'     => in_array($verifychar->Class, [64, 65, 66]) ? $verifychar->Leadership : null,
            'image'       => $verifychar->Imagem,
            'map'         => $verifychar->MapNumber,
            'mapx'        => $verifychar->MapPosX,
            'mapy'        => $verifychar->MapPosY,
            'resets'      => $verifychar->{columns_score_perfil['resets']} ?? 0,
            'mresets'     => $verifychar->{columns_score_perfil['mresets']} ?? 0,
            'killer'      => $verifychar->{columns_score_perfil['killer']} ?? 0,
            'hero'        => $verifychar->{columns_score_perfil['hero']} ?? 0,
            'bloc_profile'=> $verifychar->Bloc_Profile ?? 0,
        ];

        return $profile;
    }
}
