<?php

namespace Amwdeveloper\controller;

use Amwdeveloper\core\confirmEmail;
use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use Amwdeveloper\plugins\whatsapp\send;

class register extends layer
{
    public $message;
    public $session;

    public function account($request)
    {
        $this->message = new message();
        $this->session = new session();

        // 📌 Captura dos dados do formulário
        $name = filter_var($request['name'], FILTER_SANITIZE_SPECIAL_CHARS);
        $user = filter_var($request['user'], FILTER_SANITIZE_SPECIAL_CHARS);
        $passwd = filter_var($request['passwd'], FILTER_SANITIZE_SPECIAL_CHARS);
        $repasswd = filter_var($request['repasswd'], FILTER_SANITIZE_SPECIAL_CHARS);
        $email = filter_var($request['email'], FILTER_VALIDATE_EMAIL);
        $reemail = filter_var($request['reemail'], FILTER_VALIDATE_EMAIL);
        $pid = $request['pid'];
        $terms = isset($request['terms']) ? true : false;

        // 📌 Captura o código de referência da URL (ex: register?ref=XXXX)
        $idRef = isset($_GET['ref'])
            ? filter_var($_GET['ref'], FILTER_SANITIZE_FULL_SPECIAL_CHARS)
            : null;

        /** 🧱 Proteção contra flood */
        if (requests_form("fail_register", 5, 10)) {
            $this->message->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        /** 🧱 Validações básicas */
        if (empty($name) or empty($user) or empty($passwd) or empty($email)) {
            $this->message->class("error")->text("Campos <em><strong>obrigatórios</strong></em> vazios")->flash();
            return null;
        }

        /** 🔠 Nome */
        if (strlen($name) < 4 or strlen($name) > 10 or !preg_match("/^[a-zA-Z]+$/i", $name)) {
            $this->message->class("error")->text("Seu nome deve conter 4 à 10 letras, sem acentuação ou números.")->flash();
            return null;
        }

        /** 👤 Usuário */
        if (strlen($user) < 4 or strlen($user) > 10) {
            $this->message->class("error")->text("Seu usuário deve conter 4 à 10 caracteres")->flash();
            return null;
        }
        if (!preg_match("/^[a-zA-Z0-9]+$/i", $user)) {
            $this->message->class("error")->text("Não use símbolos em seu usuário")->flash();
            return null;
        }

        /** 🔒 Senha */
        if ((strlen($passwd) < 4 or strlen($repasswd) < 4) or (strlen($passwd) > 10 or strlen($repasswd) > 10)) {
            $this->message->class("error")->text("Sua senha deve conter entre 4 à 10 caracteres")->flash();
            return null;
        }
        if (!preg_match("/^[a-zA-Z0-9]+$/i", $passwd)) {
            $this->message->class("error")->text("Não use símbolos em sua senha")->flash();
            return null;
        }
        if ($passwd != $repasswd) {
            $this->message->class("error")->text("As senhas não conferem")->flash();
            return null;
        }

        /** 📧 E-mail */
        if (empty($email) or empty($reemail)) {
            $this->message->class("error")->text("Digite um e-mail válido")->flash();
            return null;
        }
        if ($email != $reemail) {
            $this->message->class("error")->text("Os e-mails não conferem")->flash();
            return null;
        }

        /** 🆔 Personal ID */
        if (!is_numeric($pid) or strlen($pid) != 7) {
            $this->message->class("error")->text("Seu Personal ID deve conter 7 números")->flash();
            return null;
        }

        /** ✅ Termos */
        if (!$terms) {
            $this->message->class("error")->text("Aceite os termos para continuar")->flash();
            return null;
        }

        /** 🔎 Verificações duplicadas */
        $verificationaccount = $this->table("MEMB_INFO")->columns("memb___id")->where("memb___id = :mi", "mi={$user}")->get();
        if (!empty($verificationaccount)) {
            $this->message->class("error")->text("Usuário já existe")->flash();
            return null;
        }

        $verificationemail = $this->table("MEMB_INFO")->columns("mail_addr")->where("mail_addr = :email", "email={$email}")->get();
        if (!empty($verificationemail)) {
            $this->message->class("error")->text("E-mail já cadastrado")->flash();
            return null;
        }

        if (requests_form("account_register", 2, 15)) {
            $this->message->class("error")->text("Você criou uma conta recentemente. Aguarde 15 minutos.")->flash();
            return null;
        }

        /** 🧾 Inserção da nova conta */
        $codding = uniqid();

        $dataaccount = [
            'memb___id' => trim($user),
            'memb__pwd' => trim($passwd),
            'memb_name' => trim(ucfirst($name)),
            'sno__numb' => '111111' . $pid,
            'bloc_code' => 0,
            'ctl1_code' => 1,
            'mail_addr' => $email,
            'appl_days' => '2003-01-01 00:00:00',
            'mail_chek' => config['confirm_email'] ? 0 : 1,
            'id_ref' => uniqid(), // Código único de indicação do jogador
            'email_codding' => config['confirm_email'] ? $codding : null
        ];

        // Se existir tabela de curr_info
        if (register['curr_info']) {
            $currinfo = [
                'ends_days' => '2005',
                'chek_code' => 1,
                'memb___id' => trim($user),
                'memb_name' => trim(ucfirst($name)),
                'memb_guid' => '1',
                'sno__numb' => '7',
                'used_time' => '1234',
                'Bill_Section' => '6',
                'Bill_Value' => '3',
                'Bill_Hour' => '6',
                'Surplus_Point' => '6',
                'Surplus_Minute' => '1905-06-26 00:00:00.000',
                'Increase_Days' => '0',
            ];
            $this->table("VI_CURR_INFO")->created($currinfo);
        }

        $this->table("MEMB_INFO")->created($dataaccount);

        /** 🎁 VIP Inicial */
        $messageUpdateVip = "";
        if (register['gift_vip']['active']) {
            $update = [
                config['column_vip'] => register['gift_vip']['type_vip'],
                'AccountExpireDate' => __updatedate("now", register['gift_vip']['time_vip'])
            ];
            $this->table("MEMB_INFO")->where("memb___id = :mi", "mi={$user}")->updated($update);
            $messageUpdateVip = "<br><em><strong>Você ganhou " . register['gift_vip']['time_vip'] . " dias de VIP!</strong></em>";
        }

        /** 🔗 Sistema de Indicação */
        if ($idRef) {
            $userRef = $this->table("MEMB_INFO")->columns("memb___id")->where("id_ref = :r", "r={$idRef}")->get();
            if ($userRef) {
                $ref = [
                    'user_ref' => $userRef->memb___id,
                    'account_new' => $user,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'created_at' => date("Y-m-d H:i:s")
                ];
                $this->table("amw_indication")->created($ref);
            }
        }

        /** 📧 Envio de e-mail de confirmação (opcional) */
        if (config['confirm_email']) {
            $sendMailConfirm = new confirmEmail();
            $sendMailConfirm->sendmail($email);
        }

        /** ✅ Mensagem final */
        $this->message->class("success")->text("Conta criada com sucesso {$messageUpdateVip}")->flash(true, true);
        $this->session->set('token_csrf', md5(uniqid()));
    }
}
